<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MobileApp\AuthController;
use App\Http\Controllers\MobileApp\CartController;
use App\Http\Controllers\Api\Website\FaqController;
use App\Http\Controllers\MobileApi\WinchController;
use App\Http\Controllers\MobileApp\OrderController;
use App\Http\Controllers\Api\Website\HomeController;
use App\Http\Controllers\MobileApp\AboutUsController;
use App\Http\Controllers\MobileApp\UserCarController;
use App\Http\Controllers\MobileApp\FeedbackController;
use App\Http\Controllers\Api\Website\ContactController;
use App\Http\Controllers\MobileApp\ContactUsController;
use App\Http\Controllers\MobileApp\SparePartController;
use App\Http\Controllers\MobileApp\CarForSaleController;
use App\Http\Controllers\MobileApp\CategoriesController;
use App\Http\Controllers\MobileApp\TowRequestController;
use App\Http\Controllers\MobileApp\GovernoratesController;
use App\Http\Controllers\MobileApp\NotificationController;
use App\Http\Controllers\MobileApp\ServiceCenterController;
use App\Http\Controllers\MobileApp\TermsConditionsController;
use App\Http\Controllers\MobileApp\CustomPartRequestController;
use App\Http\Controllers\MobileApp\HomeController as mobileHome;

Route::prefix('mobile')->group(function () {
    // Public Routes
    Route::get('/home', [mobileHome::class, 'index']);
    //   Route::get('/categories-with-brands-and-models', [CategoriesController::class, 'getCategoriesWithBrandsAndModels']);
    Route::get('/governorates-with-cities', [GovernoratesController::class, 'getGovernoratesWithCities']);
    Route::get('/governorates', [GovernoratesController::class, 'index']);
    Route::post('/register', [AuthController::class, 'register']);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('/reset-password', [AuthController::class, 'resetPassword']);
    Route::get('/spare-parts', [SparePartController::class, 'index']);
    Route::get('/spare-parts/{id}', [SparePartController::class, 'show']);

    Route::get('/categories', [SparePartController::class, 'categories']);
    Route::get('/about-us', [AboutUsController::class, 'index']);
    Route::get('/terms-conditions', [TermsConditionsController::class, 'index']);
    Route::get('/contact-us', [ContactUsController::class, 'index']);
    Route::get('/services-center', [ServiceCenterController::class, 'index']);
    Route::get('/services-center/{id}', [ServiceCenterController::class, 'show']);


    Route::post('/feedback', [FeedbackController::class, 'store']);
    Route::post('/complain', [FeedbackController::class, 'complain']);

    Route::prefix('cars-for-sale')->group(function () {
        Route::get('/', [CarForSaleController::class, 'index']);
        Route::middleware('auth:sanctum')->post('/', [CarForSaleController::class, 'store']);
        Route::get('/{id}', [CarForSaleController::class, 'show']);
    });

    // Route::get('/governorates', [CategoriesController::class, 'index']);

    // Protected Routes
    Route::middleware('auth:sanctum')->group(function () {


        Route::prefix('custom-part-requests')->group(function () {
            Route::post('/', [CustomPartRequestController::class, 'store'])->name('custom-part-requests.store');
            Route::get('/', [CustomPartRequestController::class, 'index'])->name('custom-part-requests.index');
            Route::get('/data', [CustomPartRequestController::class, 'data'])->name('custom-part-requests.data');
        });

        Route::prefix('winch')->group(function () {
            Route::get('/', [WinchController::class, 'index']);
            Route::post('/', [WinchController::class, 'store']);
        });


        Route::post('/logout', [AuthController::class, 'logout']);

        Route::prefix('user/')->group(function () {
            Route::post('profile', [AuthController::class, 'updateProfile']);
            Route::get('data', [AuthController::class, 'userData']);
            Route::delete('delete/account', [AuthController::class, 'deleteAccount']);
        });

        Route::post('/save-device-token', [AuthController::class, 'saveDeviceToken']);
        Route::get('/cart', [CartController::class, 'index']);
        Route::post('/cart/add', [CartController::class, 'add']);
        Route::put('/cart/update/{id}', [CartController::class, 'update']);
        Route::delete('/cart/remove/{id}', [CartController::class, 'remove']);
        Route::get('/notifications', [NotificationController::class, 'index']);
        // Route::get('/orders', [OrderController::class, 'index']);
        // Route::post('/orders', [OrderController::class, 'store']);
        // Route::get('/orders/{id}', [OrderController::class, 'show']);
        Route::post('/custom-part-requests', [CustomPartRequestController::class, 'store']);
        Route::get('/custom-part-requests', [CustomPartRequestController::class, 'index']);
        // Route::post('/tow-requests', [TowRequestController::class, 'store']);
        // Route::get('/tow-requests', [TowRequestController::class, 'index']);

        Route::prefix('user-cars')->group(function () {
            Route::post('/', [UserCarController::class, 'store']);
            Route::get('/', [UserCarController::class, 'index']);
            Route::get('/data', [UserCarController::class, 'data']);
            Route::put('/{id}', [UserCarController::class, 'update']);
            Route::delete('/{id}', [UserCarController::class, 'destroy']);
        });


    });
});
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('/home', [HomeController::class, 'index']);
Route::post('/contacts', [ContactController::class, 'store']);
Route::get('/faqs', [FaqController::class, 'index']);