@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')

<div class="page-body">
    <!-- Modal -->
    <!-- Button trigger modal -->
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">الموظفين</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}"
                                style="font-family: 'Cairo', sans-serif;">الرئيسيــــــة</a></li>
                        <li class="breadcrumb-item" style="font-family: 'Cairo', sans-serif;">الموظفين</li>
                    </ol>
                </div>
                <div class="col-sm-6">
                </div>
            </div>
        </div>
    </div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <!-- DOM / jQuery  Starts-->
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            @can('admin.users.create')
                            <!-- Trigger button -->
                            <button type="button" class="btn btn-success btn-lg" data-bs-toggle="modal"
                                data-bs-target="#userModal">
                                أضــــافة
                            </button>
                            @endcan

                        </div>
                        <br>
                        <div class="table-responsive">
                            <table class="display datatables" id="dt-plugin-method">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الاسم</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الايميل</th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            الهاتف</th>

                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            النوع </th>
                                        <th
                                            style="font-family: 'Cairo', sans-serif;font-weight:400;font-size:12px;text-align:center">
                                            العمليــــات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 0; ?>
                                    @foreach($employees as $employee)
                                    <tr>
                                        <?php $i++; ?>
                                        <td>{{$i}}</td>
                                        <td>
                                            {{$employee->name}}
                                        </td>
                                        <td style="font-family: 'Cairo', sans-serif;"> {{$employee->email}}</td>
                                        <td style="font-family: 'Cairo', sans-serif;"> {{$employee->phone}}</td>
                                        <td>
                                            @foreach($roles as $role)
                                            @if($employee->type == $role->name)
                                            {{ $role->name }}
                                            @endif
                                            @endforeach

                                        </td>
                                        <td>
                                            @can('admin.users.edit')
                                            <button class="btn btn-success" type="button" data-bs-toggle="modal"
                                                data-original-title="test" data-bs-target="#edit{{$employee->id}}"><i
                                                    class="fa fa-edit"></i>
                                            </button>
                                            @endcan

                                            @can('admin.users.delete')
                                            <button class="btn btn-danger" type="button" data-bs-toggle="modal"
                                                data-original-title="test"
                                                data-bs-target="#exampleModal{{$employee->id}}"><i
                                                    class="fa fa-remove"></i>
                                            </button>
                                            @endcan

                                        </td>
                                    </tr>
                                    <!-- Edit User Modal -->
                                    <div class="modal fade" id="edit{{$employee->id}}" tabindex="-1"
                                        aria-labelledby="editUserModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="editUserModalLabel">تعديل مستخدم</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form enctype="multipart/form-data" method="post"
                                                        action="{{route('users.update', $employee->id)}}">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="editName" class="form-label">الأسم</label>
                                                            <input type="text" class="form-control" id="editName"
                                                                name="name" value="{{ $employee->name }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editEmail" class="form-label">البريد
                                                                الألكتروني</label>
                                                            <input type="email" class="form-control" id="editEmail"
                                                                name="email" value="{{ $employee->email }}" required>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editPassword" class="form-label">كلمة
                                                                المرور</label>
                                                            <input type="password" class="form-control"
                                                                id="editPassword" name="password">
                                                            <small class="text-muted">اترك الحقل فارغًا إذا كنت لا تريد
                                                                تغيير كلمة المرور</small>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editAddress" class="form-label">العنوان</label>
                                                            <input type="text" class="form-control" id="editAddress"
                                                                name="address" value="{{ $employee->address }}">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editPhone" class="form-label">رقم الهاتف</label>
                                                            <input type="text" class="form-control" id="editPhone"
                                                                name="phone" value="{{ $employee->phone }}">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="editType" class="form-label">نوع
                                                                المستخدم</label>
                                                            <select class="form-select" id="editType" name="type">
                                                                @foreach($roles as $role)
                                                                <option value="{{ $role->name }}" {{ $employee->type
                                                                    ==
                                                                    $role->name ? 'selected' : '' }}>
                                                                    {{ $role->name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary"
                                                                data-bs-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-primary">حفظ
                                                                التغييرات</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- delete_modal_Grade -->
                                    <div class="modal fade" id="exampleModal{{$employee->id}}" tabindex="-1"
                                        role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">حذف </h5>
                                                    <button class="btn-close" type="button" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <form action="{{route('users.destroy',$employee->id)}}" method="post">
                                                    {{ method_field('Delete') }}
                                                    @csrf
                                                    <input id="id" type="hidden" name="id" class="form-control"
                                                        value="{{ $employee->id }}">
                                                    <div class="modal-body">هل أنت متاكد من عملية الحذف</div>
                                                    <div class="modal-footer">
                                                        <button class="btn btn-primary" type="button"
                                                            data-bs-dismiss="modal">غلق</button>
                                                        <button class="btn btn-secondary" type="submit">حذف</button>
                                                    </div>
                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- DOM / jQuery  Ends-->
        </div>
    </div>

    <!-- Container-fluid Ends-->
</div>
@include('dashboard.pages.users.model_add',['roles'=>$roles])
@endsection
@section('js')
@include('dashboard.layouts.js')

@endsection