@extends('admin.layouts.master')
@section('title')

@endsection
@section('css')
@include('admin.layouts.css')
@endsection
@section('body')
@if(session('error'))

@endif


<!-- Page Sidebar Ends-->
<div class="page-body">

    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 style="font-family: 'Cairo', sans-serif;">اضــــافة منتـــج جديــــد</h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">الرئيســـــية</a></li>
                        <li class="breadcrumb-item"> <a href="https://taqiviolet.com/admin/dashboard"
                                style="font-family: 'Cairo', sans-serif;">المنتجــــات</a> </li>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <div class="bookmark">

                    </div>
                </div>
            </div>
        </div>
    </div>
    @if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5 style="font-family: 'Cairo', sans-serif;">اضافـــــــة منتـــج جديـــد</h5>
                    </div>
                    <div class="card-body">
                        <form class="needs-validation" method="POST" enctype="multipart/form-data"
                            action="{{ route('admin.products.store') }}">
                            @csrf
                            <div class="col-sm-12 col-xl-12 xl-100">
                                <div class="card">
                                    <div class="card-body">
                                        <ul class="nav nav-tabs" id="icon-tab" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" id="icon-home-tab" data-bs-toggle="tab"
                                                    href="#icon-home" role="tab" aria-controls="icon-home"
                                                    aria-selected="true" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة العربية
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" id="profile-icon-tab" data-bs-toggle="tab"
                                                    href="#profile-icon" role="tab" aria-controls="profile-icon"
                                                    aria-selected="false" style="font-family: 'Cairo', sans-serif;">
                                                    اللغة الانجليزية
                                                </a>
                                            </li>
                                        </ul>
                                        <br>
                                        <div class="tab-content" id="icon-tabContent">
                                            <!-- Arabic Tab -->
                                            <div class="tab-pane fade show active" id="icon-home" role="tabpanel"
                                                aria-labelledby="icon-home-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة العربية
                                                        </label>
                                                        <input name="name_ar" class="form-control" id="name_ar"
                                                            type="text" value="" required>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_ar" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة العربية
                                                        </label>
                                                        <input name="short_details_ar" class="form-control"
                                                            id="short_details_ar" type="text" value="" required>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="col-md-12">
                                                    <label for="long_description_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف تفصيلي باللغة العربية
                                                    </label>
                                                    <textarea name="long_description_ar" id="editor_long_description_ar"
                                                        rows="10" class="form-control" required></textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="sizes_measures_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف المقاسات باللغة العربية
                                                    </label>
                                                    <textarea name="sizes_measures_ar" id="editor_sizes_measures_ar"
                                                        rows="5" class="form-control" required></textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="delivery_restore_ar" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        سياسة الارجاع الخاصة بالمنتج باللغة العربية
                                                    </label>
                                                    <textarea name="delivery_restore_ar" id="editor3" rows="5"
                                                        class="form-control" required></textarea>
                                                </div>
                                            </div>
                                            <!-- English Tab -->
                                            <div class="tab-pane fade" id="profile-icon" role="tabpanel"
                                                aria-labelledby="profile-icon-tab">
                                                <div class="row g-3">
                                                    <div class="col-md-6">
                                                        <label for="name_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            اسم المنتج باللغة الإنجليزية
                                                        </label>
                                                        <input name="name_en" class="form-control" id="name_en"
                                                            type="text" value="" required>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label for="short_details_en" class="mr-sm-2"
                                                            style="font-family: 'Cairo', sans-serif;">
                                                            وصف قصير باللغة الإنجليزية
                                                        </label>
                                                        <input name="short_details_en" class="form-control"
                                                            id="short_details_en" type="text" value="" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="long_description_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف تفصيلي باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="long_description_en" id="editor_long_description_en"
                                                        rows="10" class="form-control" required></textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="sizes_measures_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        وصف المقاسات باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="sizes_measures_en" id="editor_sizes_measures_en"
                                                        rows="5" class="form-control" required></textarea>
                                                </div>
                                                <div class="col-md-12">
                                                    <label for="delivery_restore_en" class="mr-sm-2"
                                                        style="font-family: 'Cairo', sans-serif;">
                                                        سياسة الارجاع الخاصة بالمنتج باللغة الإنجليزية
                                                    </label>
                                                    <textarea name="delivery_restore_en" id="editor3" rows="5"
                                                        class="form-control" required></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Product Info Section -->
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="serail_no" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">كود
                                        المنتج</label>
                                    <input name="serail_no" class="form-control" id="serail_no" type="text" value=""
                                        required>
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="old_price" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">سعر
                                        المنتج القديم</label>
                                    <input name="old_price" class="form-control" id="old_price" type="number" value=""
                                        required>
                                </div>
                                <div class="col-md-3">
                                    <label for="current_price" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">سعر المنتج الحالي</label>
                                    <input name="current_price" class="form-control" id="current_price" type="number"
                                        value="" required>
                                </div>
                            </div>

                            <br>
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label for="quantity" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">الكمية</label>
                                    <input name="quantity" class="form-control" id="quantity" type="number" value=""
                                        required>
                                </div>

                                <div class="col-md-3">
                                    <label for="CategoryID" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">اسم القسم</label>
                                    <div class="box dropdown-content">
                                        <select name="CategoryID" id="category_id" class="form-control" required>
                                            <option value="" disabled>اختر القسم</option>
                                            @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{
                                                $category->getTranslation('name','ar') ??null }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <label for="CategoryID" class="mr-sm-2"
                                        style="font-family: 'Cairo', sans-serif;">اسم المتجر</label>
                                    <div class="box dropdown-content">
                                        <select name="store_id" id="store_id" class="form-control" required>
                                            <option value="" disabled>اختر المتجر</option>
                                            @foreach ($stores as $store)
                                            <option value="{{ $store->id }}">{{ $store->getTranslation('name','ar')
                                                ??null }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row g-3">
                                <div class="col-md-8 mb-5">
                                    <label for="image" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">الصورة
                                        الرئيسية</label>
                                    <input name="image" class="form-control" type="file" accept="image/*">
                                </div>
                                <div class="col-md-8 mb-5">
                                    <label for="images" class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">معرض
                                        الصور</label>
                                    <input name="images[]" class="form-control" type="file" accept="image/*" multiple>
                                </div>
                            </div>

                            <button class="btn btn-primary" type="submit">حفـــظ</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
</div>

@endsection
@section('js')
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const editors = [
            'editor_long_description_en',
            'editor_sizes_measures_en',
            'editor_long_description_ar',
            'editor_sizes_measures_ar'
        ];

        editors.forEach(editorId => {
            CKEDITOR.replace(editorId, {
                language: editorId.includes('_ar') ? 'ar' : 'en'
            });
        });
    });
</script>
@include('admin.layouts.js')

@endsection