@extends('dashboard.layouts.master')
@section('title')

@endsection
@section('css')
@include('dashboard.layouts.css')
@endsection
@section('body')
<!-- Page Sidebar Ends-->
<div class="page-body">
    <div class="container-fluid">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3>انشاء مقالة </h3>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{url('admin/dashboard')}}">لوحة التحكم</a></li>
                        <li class="breadcrumb-item">الإعدادات</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h5>انشاء مقالة</h5>
                    </div>
                    <div class="card-body">
                        <form method="post" action="{{ route('blogs.store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label">العنوان عربي</label>
                                    <input type="text" name="title_ar" class="form-control"
                                        value="{{ old('title_ar') }}" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label"> العنوان انجليزي</label>
                                    <input type="text" name="title_en" class="form-control"
                                        value="{{ old('title_en') }}" required>
                                </div>
                                <!-- Arabic Content Section -->
                                <div class="col-md-6 mt-3">
                                    <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">محتوي قصير
                                        بالعربية</label>
                                    <textarea id="editor1" name="content_ar" rows="5"
                                        class="form-control">{{ old('content_ar') }}</textarea>
                                </div>

                                <!-- English Content Section -->
                                <div class="col-md-6 mt-3">
                                    <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">محتوي قصير
                                        بالإنجليزية</label>
                                    <textarea id="" name="content_en" rows="5"
                                        class="form-control">{{ old('content_en') }}</textarea>
                                </div>
                                <!-- Arabic Content Section -->
                                <div class="col-md-12 mt-3">
                                    <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">المحتوى
                                        بالعربية</label>
                                    <textarea id="editor1" name="long_content_ar" rows="10"
                                        class="form-control">{{ old('long_content_ar') }}</textarea>
                                </div>

                                <!-- English Content Section -->
                                <div class="col-md-12 mt-3">
                                    <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">المحتوى
                                        بالإنجليزية</label>
                                    <textarea id="" name="long_content_en" rows="10"
                                        class="form-control">{{ old('long_content_en') }}</textarea>
                                </div>

                                <!-- Category Selection -->
                                <div class="mb-2 mt-3">
                                    <label class="col-form-label">اختار انتماء المدونه</label>
                                    <select class="js-example-basic-multiple col-sm-12 select2-hidden-accessible"
                                        name="id_blog" tabindex="-1" aria-hidden="true">
                                        <option value="">اختر</option>
                                        @foreach ($items as $item)
                                        <option value="{{ $item->id }}">{{ $item->Title }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">صوره
                                            خارجيه</label>
                                        <input type="file" name="image" class="form-control"
                                            style="border:solid 1px #555;">
                                    </div>
                                </div>
                                <div class="row g-3">
                                    <div class="col-md-12">
                                        <label class="mr-sm-2" style="font-family: 'Cairo', sans-serif;">صوره
                                            داخليه</label>
                                        <input type="file" name="imageInside" class="form-control"
                                            style="border:solid 1px #555;">
                                    </div>
                                </div>
                            </div>

                            <br>
                            <button class="btn btn-primary" type="submit">حفظ</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection
@section('js')
@include('dashboard.layouts.js')


@endsection