<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Translatable;

class Governorate extends Model
{
    use Translatable;

    protected $fillable = ['name'];

    protected $casts = [
        'name' => 'array',
    ];

    public function cities()
    {
        return $this->hasMany(City::class);
    }

    public function getNameAttribute($value)
    {
        return $this->translateName($value);
    }
}