<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Translatable;

class City extends Model
{
    use Translatable, HasFactory;

    protected $fillable = ['name', 'governorate_id'];

    protected $casts = [
        'name' => 'array',
    ];

    public function governorate()
    {
        return $this->belongsTo(Governorate::class);
    }


    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function vendors()
    {
        return $this->hasMany(Vendor::class);
    }

    public function spareParts()
    {
        return $this->hasMany(SparePart::class);
    }

}