<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = ['spare_part_id', 'cart_id', 'quantity', 'price'];

    public function sparePart()
    {
        return $this->belongsTo(SparePart::class);
    }

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }
}