<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SparePartResource extends JsonResource
{
    public function toArray($request)
    {
        $locale = $request->header('Accept-Language', 'ar');
        $locale = in_array($locale, ['ar', 'en']) ? $locale : 'ar';

        return [
            'id' => $this->id,
            'name' => json_decode($this->name, true)[$locale] ?? null,
            'category_id' => $this->category_id,
            'category_name' => $this->category ? json_decode($this->category->name, true)[$locale] ?? null : null,
            'vendor_id' => $this->vendor_id,
            'vendor_name' => $this->vendor ? json_decode($this->vendor->name, true)[$locale] ?? null : null,
            'price' => $this->price,
            'image' => $this->image,
            'description' => $this->description,
            'is_active' => $this->is_active,
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}