<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SiteDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array
     */
    public function toArray(Request $request): array
    {

        return [
            'id' => $this->id,
            'key' => $this->key,
            'title' => $this->title,
            'short_description' => $this->short_description,
            'body' => $this->body,
            'image' => $this->image ? $this->image->path : null,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}