<?php

namespace App\Http\Controllers\Api\Website;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\BlogResource;
use App\Http\Resources\SiteDetailResource;
use App\Models\Blog;
use App\Models\SiteDetail;
class HomeController extends Controller
{
    public function index()
    {

        // $siteDetails = SiteDetail::with('image')->get();
        $section_download_app = SiteDetail::where('key', 'section_download_app')->with('image')->latest()->first();
        $second_section = SiteDetail::where('key', 'second_section')->with('image')->get();
        $terms_condition = SiteDetail::where('key', 'terms_condition')->with('image')->get();
        $second_section_step = SiteDetail::where('key', 'second_section_step')->with('image')->get();

        $header_section = SiteDetail::where('key', 'header_section')->with('image')->latest()->first();
        $third_section = SiteDetail::where('key', 'third_section')->with('image')->latest()->first();

        return response()->json([
            'message' => 'data retrieved successfully',
            'site_header' => $header_section ? new SiteDetailResource($header_section) : null,
            'second_section' => SiteDetailResource::collection($second_section),
            'section_download_app' => $section_download_app ? new SiteDetailResource($section_download_app) : null,
            'third_section' => $third_section ? new SiteDetailResource($third_section) : null,
            'terms_condition' => $terms_condition ? SiteDetailResource::collection($terms_condition) : null,
            'second_section_step' => $second_section_step ? SiteDetailResource::collection($second_section_step) : null,
        ]);
    }

}